@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Wishlist')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs :pages="[ __('Wishlist') => translatedRoute('wishlist.index') ]"/>

    @if($products->isEmpty())
        <div class="page-404 component-border-radius">
            <div class="container">
                <div class="row">
                    <div class="col-12 offset-md-1 col-md-10 offset-lg-3 col-lg-6">
                        <div class="page-404__wrapper">
                            <div class="wrapper">
                                <span class="label">{{ __('Your wishlist is currently empty') }}</span>
                                <p>{{ __('Your wishlist is currently empty. Add products to your wishlist in order to save it.') }}</p>
                            </div>

                            <hr>

                            <nav class="buttons">
                                <a href="{{ translatedRoute('page') }}" class="button--arrow">{{ __('Back to home') }} <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645"><g transform="translate(0.75 1.06)"><path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/><path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761" transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/></g></svg></a>
                                <a href="{{ translatedRoute('products.index') }}" class="button--arrow">{{ __('Browse products') }} <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645"><g transform="translate(0.75 1.06)"><path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/><path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761" transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/></g></svg></a>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        <x-page-header :title="__('Wishlist')"/>
        <main class="component-wrapper">
            <section class="news-archive component-border-radius component-white">
                <div class="container">
                    <div class="row gy-5">
                        @foreach($products as $product)
                            <div class="col-12 col-md-6 col-lg-3 mb-4">
                                <livewire:products.card
                                    :product="$product"
                                    class="product-card--border"
                                />
                            </div>
                        @endforeach

                        <div class="col-12 mb-8">
                            <div class="news-archive__pagination">
                                {{ $products->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </main>
    @endif
</x-layouts.app>
