<?php

namespace App\Components;

use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class CTA extends Component
{
    public string $type = 'cta';

    public function name(): string
    {
        return __('CTA');
    }

    public function fields(): Collection
    {
        return collect([
            Field::media('image', __('Image')),
            Field::text('title', __('Title'))->required(),
            Field::wysiwyg('content', __('Content'))->required(),
            Field::button('button', __('Button')),
        ]);
    }
}
