<?php

namespace App\Components;

use App\Models\Testimonial;
use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class Testimonials extends Component
{
    public string $type = 'testimonials';

    public function name(): string
    {
        return __('Testimonials');
    }

    public function fields(): Collection
    {
        return collect([
            Field::text('title', __('Title'))->required(),
            Field::related(
                name: 'testimonials',
                label: __('Testimonials'),
                type: Testimonial::class,
                items: Testimonial::get()
                    ->map(function (Testimonial $testimonial) {
                        return [
                            'id' => $testimonial->id,
                            'label' => $testimonial->name,
                        ];
                    })->toArray(),
            )->required(),
        ]);
    }
}
