<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use Daylight\Core\Models\Order;
use Daylight\Core\Modules\Multilingualism\Entities\LocalizedRoute;
use Illuminate\View\View;

class OrderController extends Controller
{
    public function index(): View
    {
        auth()->user()->load([
            'orders',
        ]);

        $localizedRoute = LocalizedRoute::create()
            ->setRoute('account.orders.index')
            ->staticRoute();

        return view('account.orders.index', [
            'orders' => auth()->user()->orders,
            'localizedRoute' => $localizedRoute,
        ]);
    }

    public function show(Order $order)
    {
        if (! auth()->user()->customer->orders->contains($order)) {
            return redirect()
                ->translatedRoute('account.orders.index');
        }

        $localizedRoute = LocalizedRoute::create()
            ->setRoute('account.orders.show', $order->uuid)
            ->staticRoute();

        $order->loadMissing([
            'billingAddress',
            'shippingAddress',
            'items.variant.media',
            'items.variant.product.translations',
        ]);

        return view('account.orders.show', [
            'localizedRoute' => $localizedRoute,
            'order' => $order,
        ]);
    }
}
