<?php

namespace App\Livewire\Products;

use Daylight\Core\Models\Variant;
use Livewire\Attributes\On;
use Livewire\Component;

class ArticleNumber extends Component
{
    public Variant $variant;

    #[On('current-variant-changed')]
    public function currentVariantChanged(Variant $variant): void
    {
        $this->variant = $variant;
    }

    public function render()
    {
        return view('livewire.products.article-number');
    }
}
