<?php

namespace App\Livewire\Products;

use Daylight\Core\Models\Variant;
use Illuminate\Support\Collection;
use Livewire\Attributes\On;
use Livewire\Component;

class ProductGallery extends Component
{
    public Collection $images;

    public ?string $videoUrl = null;

    #[On('current-variant-changed')]
    public function updateImages(Variant $variant)
    {
        if ($variant->getMedia() === $this->images) {
            return;
        }

        $this->images = $variant->getMedia();
        $this->videoUrl = $variant->video_url;

        $this->dispatch('gallery-images-changed', $this->images);
    }

    public function render()
    {
        return view('livewire.products.product-gallery');
    }
}
