<?php

namespace App\Modules\Wishlist;

use App\Modules\Wishlist\Contracts\WishlistInterface;
use App\Modules\Wishlist\Http\Middleware\EnsureWishlistSessionCreated;
use App\Modules\Wishlist\Livewire\Wishlist\AddToWishlist;
use App\Modules\Wishlist\Livewire\Wishlist\Button;
use Illuminate\Routing\Router;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class WishlistServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->registerLivewireComponents();
    }

    public function register(): void
    {
        $this->loadMigrationsFrom(__DIR__.'/Database/Migrations');

        $this->app->singleton(WishlistInterface::class, function () {
            return new Wishlist(
                sessionManager: session(),
            );
        });

        app(Router::class)->aliasMiddleware('wishlist', EnsureWishlistSessionCreated::class);
    }

    public function registerLivewireComponents(): self
    {
        if (! class_exists(Livewire::class)) {
            return $this;
        }

        Livewire::component('wishlist.button', Button::class);
        Livewire::component('wishlist.add-to-wishlist', AddToWishlist::class);

        return $this;
    }
}
