@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Change password')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs
        :pages="[
            __('Account') => translatedRoute('account.index'),
            __('Password') => translatedRoute('account.password'),
        ]"
    />

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                @include('account.navigation')

                <div class="col-12 col-lg-9">
                    <x-panel :title="__('Change password')">
                        <x-slot:description>
                            <p>{{ __('Fill in the fields below to change your password.') }}</p>
                        </x-slot:description>

                        <x-session-messages />

                        <form action="{{ translatedRoute('account.password') }}" method="post">
                            @csrf

                            <x-input.group
                                for="current_password"
                                :label="__('Current password')"
                                :error="$errors->first('current_password')"
                                :required="true"
                            >
                                <x-input.text
                                    id="current_password"
                                    name="current_password"
                                    type="password"
                                />

                                <x-slot:helpText>
                                    {{ __('All other devices will be signed off.') }}
                                </x-slot:helpText>
                            </x-input.group>

                            <div class="row">
                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="password"
                                        :label="__('New password')"
                                        :error="$errors->first('password')"
                                        :required="true"
                                    >
                                        <x-input.text
                                            type="password"
                                            id="password"
                                            name="password"
                                        />
                                    </x-input.group>
                                </div>

                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="password_confirmation"
                                        :label="__('New password confirmation')"
                                        :error="$errors->first('password_confirmation')"
                                        :required="true"
                                    >
                                        <x-input.text
                                            type="password"
                                            id="password_confirmation"
                                            name="password_confirmation"
                                        />
                                    </x-input.group>
                                </div>
                            </div>

                            <div class="text-right mt-4">
                                <button class="button button--primary" type="submit">
                                    {{ __('Change password') }}
                                </button>
                            </div>
                        </form>
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
