@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Verify email')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs :pages="[ __('Verify email') => translatedRoute('verification.notice') ]" />

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6">
                    <x-panel :title="__('Verify your email')">
                        <x-slot:description>
                            <p>{{ __('Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you?') }}</p>
                            <p>{{ __('If you didn\'t receive the email, we will gladly send you another.') }}</p>
                        </x-slot:description>

                        @if (session('status') == 'verification-link-sent')
                            <div class="alert alert--success">
                                {{ __('A new verification link has been sent to the email address you provided during registration.') }}
                            </div>
                        @endif

                        <div class="row mt-4">
                            <div class="col-6">
                                <form method="POST" action="{{ translatedRoute('verification.send') }}">
                                    @csrf

                                    <div>
                                        <button type="submit" class="button button--primary">
                                            {{ __('Resend Verification Email') }}
                                        </button>
                                    </div>
                                </form>
                            </div>

                            <div class="col-6 text-right">
                                <form method="POST" action="{{ translatedRoute('logout') }}">
                                    @csrf

                                    <button type="submit" class="button button--link" style="padding-right: 0;">
                                        {{ __('Log Out') }}
                                    </button>
                                </form>
                            </div>
                        </div>
                    </x-panel>
                </div>

                <div class="col-12 col-lg-6">
                    <x-panel :title="__('Benefits from an account')">
                        <x-slot:description>
                            <p>
                                Verify your email address to enjoy a personalized shopping experience. With an account, you can easily manage your orders, save your favorite products, and receive exclusive offers.
                            </p>
                        </x-slot:description>

                        <x-contact-cta />
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
