@props(['block', 'lazyLoading' => false])

<section class="content-image component-border-radius {{ $block->data['background'] === 'white' ? 'component-white' : '' }}">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-12 col-lg-4">
                <div class="content-image__content">
                    @isset($block->data['title'])
                        <h2 class="title">{{ $block->data['title'] }}</h2>
                    @endif

                    @isset($block->data['content'])
                        {!! $block->data['content'] !!}
                    @endif
                </div>
            </div>
            <div class="col-12 offset-lg-1 col-lg-7">

                @if($image = $block->media->firstWhere('pivot.properties.field', 'image'))
                    <figure class="content-image__image">
                        <img
                            src="{{ $image->getUrl() }}"
                            alt="{{ $component->data['title'] ?? '' }}"
                            loading="{{ $lazyLoading ? 'lazy': 'eager' }}"
                            fetchpriority="{{ $lazyLoading ? 'low': 'high' }}"
                        >
                    </figure>
                @endif
            </div>
        </div>
    </div>
</section>
