@props(['testimonial'])

<article class="testimonial-card">
    <div class="testimonial-card__top">
        <div class="stars">
            @for ($i = 0; $i < $testimonial->rating; $i++)
                <svg class="star active" role="img" aria-label="review star" xmlns="http://www.w3.org/2000/svg" width="13.897" height="13.308" viewBox="0 0 13.897 13.308">
                    <g id="Group_20328" data-name="Group 20328" transform="translate(0.509 0.5)">
                        <g id="Group_20329" data-name="Group 20329">
                            <path class="st0-1" id="Path_47996" data-name="Path 47996"
                                  d="M6.677,10.559l3.19,1.677a.51.51,0,0,0,.74-.538L10,8.147a.511.511,0,0,1,.146-.451L12.725,5.18a.509.509,0,0,0-.282-.868L8.877,3.794a.511.511,0,0,1-.384-.278L6.9.284a.511.511,0,0,0-.915,0l-1.6,3.233A.508.508,0,0,1,4,3.794L.436,4.312a.509.509,0,0,0-.282.868L2.735,7.7a.509.509,0,0,1,.146.451L2.273,11.7a.511.511,0,0,0,.74.538L6.2,10.559a.509.509,0,0,1,.475,0Z"
                                  transform="translate(0 0)" fill="none" stroke="#ff8126" stroke-width="1"/>
                        </g>
                    </g>
                </svg>
            @endfor
        </div>
        <small class="location">{{ $testimonial->location }}</small>
    </div>
    <div class="testimonial-card__content">
        <h3 class="title">{{ $testimonial->title }}</h3>
        <p class="content">{!! $testimonial->content !!}</p>
        <cite class="reviewer">{{ $testimonial->name }} - {{ $testimonial->company }}</cite>
    </div>
</article>
