@props([
    'small' => false
])

<div class="panel__register {{ $small ? 'panel__register--small' : '' }}">
    <h3>{{ __('Questions or need help?') }}</h3>

    <div class="panel__register-methods">
        @if($phone = app(\Daylight\Core\Settings\General::class)->phoneNumber)
            <div class="panel__register-method">
                <img src="{{ Vite::asset('resources/images/icons/icon-phone-secondary.svg') }}"
                     alt="{{ __('Phone') }}">

                <div>
                    <small>{{ __('Call us on') }}</small>
                    <p><a href="tel:{{ $phone }}">{{ $phone }}</a></p>
                </div>
            </div>
        @endif

        @if($email = app(\Daylight\Core\Settings\General::class)->email)
            <div class="panel__register-method">
                <img src="{{ Vite::asset('resources/images/icons/icon-email-secondary.svg') }}"
                     alt="{{ __('Email') }}">

                <div>
                    <small>{{ __('E-mail us on') }}</small>
                    <p><a href="mailto:{{ $email }}">{{ $email }}</a></p>
                </div>
            </div>
        @endif
    </div>

    <img src="{{ Vite::asset('resources/images/register-contact.png') }}" alt="{{ __('Contact us') }}" class="panel__register-contact">
</div>
