<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ $title }} - {{ app(\Daylight\Core\Settings\General::class)->name ?? config('app.name') }}</title>

        <link rel="icon" type="image/png" href="{{ Vite::asset('resources/images/favicon/favicon-32x32.png') }}" sizes="32x32" />
        <link rel="icon" type="image/png" href="{{ Vite::asset('resources/images/favicon/favicon-16x16.png') }}" sizes="16x16" />
        <link rel="stylesheet" href="https://use.typekit.net/tvg3uws.css">
        @yield('head')

        @livewireStyles
        @vite('resources/css/app.scss')

        @if(config('services.gtm.container_id'))
            <script>
                (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
                })(window,document,'script','dataLayer','{{ config('services.gtm.container_id') }}');
            </script>
        @else
            <script>
                console.error("Google Tag Manager container ID is not set. Please set the GTM_CONTAINER_ID environment variable.");

                const dataLayer = {
                    push: function (data) {
                        console.log("dataLayer.push", data);
                    }
                }
            </script>
        @endif
    </head>

    <body>
        @if(config('services.gtm.container_id'))
            <noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ config('services.gtm.container_id') }}" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        @endif

        {{ $slot }}

        @vite('resources/js/app.js')
        @livewireScripts
    </body>
</html>
