@extends('daylight::layouts.app')

@section('title', __('Edit :testimonial', ['testimonial' => $testimonial->name]))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('Edit :testimonial', ['testimonial' => $testimonial->name])">
            @can('delete:pages')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('Delete testimonial') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.content.testimonials.update', $testimonial) }}">
            @csrf
            @method('PUT')
            <input type="hidden" name="locale" value="{{ request()->get('locale', 'en') }}">

            <x-daylight::input.group
                :label="__('Name')"
                :error="$errors->first('name')"
                for="name"
            >
                <x-daylight::input.text name="name" id="name" value="{{ old('name', $testimonial->name) }}" />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Company')"
                :error="$errors->first('company')"
                for="company"
            >
                <x-daylight::input.text name="company" id="company" value="{{ old('company', $testimonial->company) }}" />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Location')"
                :error="$errors->first('location')"
                for="location"
            >
                <x-daylight::input.text name="location" id="location" value="{{ old('location', $testimonial->location) }}" />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Rating')"
                :error="$errors->first('rating')"
                for="rating"
            >
                <x-daylight::input.text type="number" min="1" max="5" step="1" name="rating" id="rating" value="{{ old('rating', $testimonial->rating) }}"/>
            </x-daylight::input.group>

            <x-daylight::locale-selector :route="route('daylight.content.testimonials.edit', $testimonial)"/>

            <x-daylight::input.group
                :label="__('Title')"
                :error="$errors->first('title')"
                for="title"
            >
                <x-daylight::input.text name="title" id="title" value="{{ old('title', $testimonial->title) }}" />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Content')"
                :error="$errors->first('content')"
                for="content"
            >
                <x-daylight::input.textarea name="content" id="content">{{ old('content', $testimonial->content) }}</x-daylight::input.textarea>
            </x-daylight::input.group>

            <div class="mt-6 flex items-center justify-end gap-x-3">
                <x-daylight::buttons.secondary href="{{ route('daylight.content.testimonials.index') }}" element="a">
                    {{ __('Cancel') }}
                </x-daylight::buttons.secondary>

                <x-daylight::buttons.primary type="submit">
                    {{ __('Save') }}
                </x-daylight::buttons.primary>
            </div>
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900" id="modal-title">{{ __('Delete :object', ['object' => __('testimonial')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('Are you sure you want to delete this :object? This action cannot be undone.', ['object' => __('testimonial')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.content.testimonials.destroy', $testimonial) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button" class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto" @click.prevent="showConfirmDeleteModal = false">
                        {{ __('Cancel') }}
                    </button>

                    <button type="submit" class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('Delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
