<div x-data="{ products: @entangle('dataLayerProducts') }">
    @if($searchQuery &&  $searchResult->getResults()->count() === 0)
        <x-page-header :title="__('No results found for “:searchQuery”', ['searchQuery' => $searchQuery]) "
                       centered="true"/>

        <div class="page-no-results component-border-radius">
            <div class="container">
                <div class="row">
                    <div class="col-12 offset-md-1 col-md-10 offset-lg-3 col-lg-6">
                        <div class="page-no-results__wrapper">
                            <div class="wrapper">
                                <p>{{ __('Please try again with another query') }}</p>

                                <form action="{{ translatedRoute('products.index') }}" class="search-input">
                                    <input type="text" name="q" placeholder="{{ __('What are you looking for?') }}">
                                </form>

                                <ul>
                                    <li>
                                        <svg role="img" aria-label="icon checkmark" xmlns="http://www.w3.org/2000/svg"
                                             width="13.764" height="10.036" viewBox="0 0 13.764 10.036">
                                            <path d="M3526.652-6174.925l3.855,3.854,7.789-8.226"
                                                  transform="translate(-3525.592 6180.356)" fill="none" stroke="#ff8126"
                                                  stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </svg>
                                        {{ __('Check the spelling of your search term') }}
                                    </li>
                                    <li>
                                        <svg role="img" aria-label="icon checkmark" xmlns="http://www.w3.org/2000/svg"
                                             width="13.764" height="10.036" viewBox="0 0 13.764 10.036">
                                            <path d="M3526.652-6174.925l3.855,3.854,7.789-8.226"
                                                  transform="translate(-3525.592 6180.356)" fill="none" stroke="#ff8126"
                                                  stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </svg>
                                        {{ __('Make your search term less specific') }}
                                    </li>
                                </ul>
                            </div>


                            <hr>

                            <nav class="buttons">
                                <a href="{{ translatedRoute('page') }}" class="button--arrow">
                                    {{ __('Back to home') }}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645"
                                         viewBox="0 0 10.59 9.645">
                                        <g transform="translate(0.75 1.06)">
                                            <path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)"
                                                  fill="none" stroke="#ff8126" stroke-linecap="round"
                                                  stroke-width="1.5"/>
                                            <path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761"
                                                  transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126"
                                                  stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </svg>
                                </a>
                                <a href="{{ translatedRoute('page', __('routes.customer-service')) }}"
                                   class="button--arrow">
                                    {{ __('Customer service') }}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645"
                                         viewBox="0 0 10.59 9.645">
                                        <g transform="translate(0.75 1.06)">
                                            <path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)"
                                                  fill="none" stroke="#ff8126" stroke-linecap="round"
                                                  stroke-width="1.5"/>
                                            <path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761"
                                                  transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126"
                                                  stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </svg>
                                </a>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        <div class="product-browser">
            <div class="container">
                <div class="row">
                    <div class="col-12 col-lg-3">
                        <div class="product-browser__sidebar">
                            @if($categories->isNotEmpty())
                                <div class="product-browser__widget" x-data="{ isCollapsed: false }"
                                     :class="{ 'is-collapsed': isCollapsed }">
                                    <h3 @click.prevent="isCollapsed = !isCollapsed">
                                        {{ __('Catalogue') }}
                                    </h3>

                                    <div class="product-browser__filters">
                                        <ul>
                                            @foreach($categories as $child)
                                                <li>
                                                    <a class="{{ $this->category && $this->category->id === $child->id ? 'is-active' : '' }}"
                                                       href="{{ translatedRoute('products.category', $child->translations->first()?->nestedSlug ?? '#') }}">
                                                        {{ $child->name }}
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endif

                            @foreach($searchResult->getFacets() as $facet)
                                <div class="product-browser__widget" x-data="{ isCollapsed: false }"
                                     :class="{ 'is-collapsed': isCollapsed }">
                                    <h3 @click.prevent="isCollapsed = !isCollapsed">
                                        {{ $facet->name }}
                                    </h3>

                                    <div class="product-browser__filters">
                                        @if($facet->property === 'price')
                                            <x-partials.facets.price
                                                :facet="$facet"
                                                :activeRange="$searchResult->getActiveFilters()->firstWhere('group', 'price')"
                                            />
                                        @else
                                            @foreach($facet->getFilters() as $filter)
                                                <label class="checkbox-group"
                                                       wire:key="{{ $filter->property }}-{{ $filter->key }}">
                                                    <input type="checkbox" value="{{ $filter->key }}"
                                                           wire:model.live="filters.{{ $filter->property }}">
                                                    <span>{{ $filter->name }} <span class="counter">({{ $filter->amount }})</span></span>
                                                </label>
                                            @endforeach
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="col-12 col-lg-9">
                        <div class="product-browser__header">
                            @isset($category)
                                <h1>{{ $category->translations->first()->name }}</h1>
                            @else
                                <h1>{{ __('All products') }}</h1>
                            @endif
                        </div>

                        <div class="product-browser__mobile-filter-trigger">
                            <button @click.prevent="$dispatch('toggle-slide-over', 'filters')" x-data>
                                <img src="{{ Vite::asset('resources/images/icons/icon-filters.svg') }}"
                                     alt="{{ __('Filter') }}">
                                {{ __('Filters') }}
                            </button>
                        </div>

                        <div class="product-browser__sorting">
                            <p>{{ __(':count results', ['count' => $searchResult->getResults()->count()]) }}</p>

                            <div>
                                <label for="sort_by">{{ __('Sort by') }}</label>
                                <select class="select" name="sort_by" wire:model.live="sortBy" id="sort_by">
                                    @foreach($searchResult->getSortingOptions() as $sortingOption => $label)
                                        <option wire:key="sort-1-{{ $sortingOption }}"
                                                value="{{ $sortingOption }}">{{ $label->value }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        @if($searchResult->getActiveFilters()->isNotEmpty())
                            <div class="product-browser__active-filters product-browser__active-filters--desktop">
                                <p>{{ __('Active filters') }}</p>
                                <ul>
                                    @foreach($searchResult->getActiveFilters() as $activeFilter)
                                        <li>
                                            <a href="{{ $activeFilter->deleteUrl }}">
                                                {{ $activeFilter->name }}

                                                <img src="{{ Vite::asset('resources/images/icons/icon-close-secondary.svg') }}" alt="{{ __('Close') }}">
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                                {{--                        @dump($searchResult->getActiveFilters())--}}
                            </div>
                        @endif

                        <div class="product-browser__products">
                            <div class="row">
                                @if($searchResult->getResults()->isEmpty())
                                    <div class="col-12">
                                        <div class="alert alert--info">
                                            {{ __('Your search query did not return any results.') }}
                                        </div>
                                    </div>
                                @else
                                    @foreach($searchResult->getResults() as $product)
                                        <div class="col-12 col-md-6 col-xxl-4"
                                             wire:key="product-loop-{{ $product->id }}">
                                            <livewire:products.card
                                                :$product
                                                :key="$product->id"
                                            />
                                        </div>
                                    @endforeach

                                    <div class="col-12">
                                        <div class="product-browser__pagination">
                                            {{ $searchResult->getResults()->appends(request()->input())->links() }}
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <x-slide-over name="filters" :title="__('Filters')">
            <div class="product-browser__mobile-filters">
                @if($searchResult->getActiveFilters()->isNotEmpty())
                    <div class="product-browser__active-filters">
                        <p>{{ __('Active filters') }}</p>
                        <ul>
                            @foreach($searchResult->getActiveFilters() as $activeFilter)
                                <li>
                                    <a href="{{ $activeFilter->deleteUrl }}">
                                        {{ $activeFilter->name }}
                                        <img src="{{ Vite::asset('resources/images/icons/icon-close-secondary.svg') }}"
                                             alt="{{ __('Close') }}">
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @if($categories->isNotEmpty())
                    <div class="product-browser__widget" x-data="{ isCollapsed: false }"
                         :class="{ 'is-collapsed': isCollapsed }">
                        <h3 @click.prevent="isCollapsed = !isCollapsed">
                            {{ __('Catalogue') }}
                        </h3>

                        <div class="product-browser__filters">
                            <ul>
                                @foreach($categories as $child)
                                    <li>
                                        <a class="{{ $this->category && $this->category->id === $child->id ? 'is-active' : '' }}"
                                           href="{{ translatedRoute('products.category', $child->translations->first()?->nestedSlug ?? '#') }}">
                                            {{ $child->name }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                @endif

                @foreach($searchResult->getFacets() as $facet)
                    <div class="product-browser__widget" x-data="{ isCollapsed: true }"
                         :class="{ 'is-collapsed': isCollapsed }">
                        <h3 @click.prevent="isCollapsed = !isCollapsed">
                            {{ $facet->name }}
                        </h3>

                        <div class="product-browser__filters">
                            @if($facet->property === 'price')
                                <x-partials.facets.price
                                    :facet="$facet"
                                    :activeRange="$searchResult->getActiveFilters()->firstWhere('group', 'price')"
                                />
                            @else
                                @foreach($facet->getFilters() as $filter)
                                    <label class="checkbox-group" wire:key="{{ $filter->property }}-{{ $filter->key }}">
                                        <input type="checkbox" value="{{ $filter->key }}"
                                               wire:model.live="filters.{{ $filter->property }}">
                                        <span>{{ $filter->name }} <span
                                                class="counter">({{ $filter->amount }})</span></span>
                                    </label>
                                @endforeach
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>

            <x-slot:footer>
                <div class="slide-over__buttons">
                    <button class="button button--primary button--full-width" @click.prevent="isVisible = false">
                        {{ __('Apply filters') }}
                    </button>

                    <button @click.prevent="isVisible = false" class="button button--link">
                        {{ __('Close') }}
                    </button>
                </div>
            </x-slot:footer>
        </x-slide-over>
    @endif

    @script
    <script>
        const pushDataLayerEvent = (products) => {
            dataLayer.push({ecommerce: null});

            dataLayer.push({
                event: 'view_item_list',
                ecommerce: {
                    item_list_id: 'productBrowser',
                    item_list_name: 'Product Browser',
                    items: products
                },
            });
        }

        pushDataLayerEvent($wire.dataLayerProducts);

        $wire.on('products-refreshed', event => {
            pushDataLayerEvent($wire.dataLayerProducts);
        });

        $wire.on('add-to-cart', (event) => {
            dataLayer.push({ecommerce: null});

            dataLayer.push({
                event: 'add_to_cart',
                ecommerce: {
                    items: event
                }
            });
        });
    </script>
    @endscript
</div>

