@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Products')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs
        :pages="[
            __('Products') => translatedRoute('products.index'),
           ...$category->ancestorsAndSelf->reverse()->mapWithKeys(function($category) {
               return[$category->translations->first()->name => translatedRoute('products.category', ['any' => $category->translations->first()->nestedSlug])];
           })
        ]"
    />

    <livewire:products.browser
        :category="$category"
    />

    @foreach($category->translations->first()->components as $block)
        <x-dynamic-component
            :component="'blocks.' . $block->type"
            :block="$block"
            :lazyLoading="($loop->index >= 2)"
        />
    @endforeach
</x-layouts.app>
